package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait PhoneNumberStatus {
  def unwrap: software.amazon.awssdk.services.chime.model.PhoneNumberStatus
}
object PhoneNumberStatus {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.PhoneNumberStatus
  ): zio.aws.chime.model.PhoneNumberStatus = value match {
    case software.amazon.awssdk.services.chime.model.PhoneNumberStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberStatus.ACQUIRE_IN_PROGRESS =>
      val r = AcquireInProgress
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberStatus.ACQUIRE_FAILED =>
      val r = AcquireFailed
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberStatus.UNASSIGNED =>
      val r = Unassigned
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberStatus.ASSIGNED =>
      val r = Assigned
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberStatus.RELEASE_IN_PROGRESS =>
      val r = ReleaseInProgress
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberStatus.DELETE_IN_PROGRESS =>
      val r = DeleteInProgress
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberStatus.RELEASE_FAILED =>
      val r = ReleaseFailed
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberStatus.DELETE_FAILED =>
      val r = DeleteFailed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.PhoneNumberStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AcquireInProgress extends zio.aws.chime.model.PhoneNumberStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberStatus.ACQUIRE_IN_PROGRESS
  }
  case object AcquireFailed extends zio.aws.chime.model.PhoneNumberStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberStatus.ACQUIRE_FAILED
  }
  case object Unassigned extends zio.aws.chime.model.PhoneNumberStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberStatus.UNASSIGNED
  }
  case object Assigned extends zio.aws.chime.model.PhoneNumberStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberStatus.ASSIGNED
  }
  case object ReleaseInProgress extends zio.aws.chime.model.PhoneNumberStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberStatus.RELEASE_IN_PROGRESS
  }
  case object DeleteInProgress extends zio.aws.chime.model.PhoneNumberStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberStatus.DELETE_IN_PROGRESS
  }
  case object ReleaseFailed extends zio.aws.chime.model.PhoneNumberStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberStatus.RELEASE_FAILED
  }
  case object DeleteFailed extends zio.aws.chime.model.PhoneNumberStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberStatus =
      software.amazon.awssdk.services.chime.model.PhoneNumberStatus.DELETE_FAILED
  }
}
