package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait PhoneNumberType {
  def unwrap: software.amazon.awssdk.services.chime.model.PhoneNumberType
}
object PhoneNumberType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.PhoneNumberType
  ): zio.aws.chime.model.PhoneNumberType = value match {
    case software.amazon.awssdk.services.chime.model.PhoneNumberType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberType.LOCAL =>
      val r = Local
      r
    case software.amazon.awssdk.services.chime.model.PhoneNumberType.TOLL_FREE =>
      val r = TollFree
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.PhoneNumberType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberType =
      software.amazon.awssdk.services.chime.model.PhoneNumberType.UNKNOWN_TO_SDK_VERSION
  }
  case object Local extends zio.aws.chime.model.PhoneNumberType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberType =
      software.amazon.awssdk.services.chime.model.PhoneNumberType.LOCAL
  }
  case object TollFree extends zio.aws.chime.model.PhoneNumberType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.PhoneNumberType =
      software.amazon.awssdk.services.chime.model.PhoneNumberType.TOLL_FREE
  }
}
