package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait ProxySessionStatus {
  def unwrap: software.amazon.awssdk.services.chime.model.ProxySessionStatus
}
object ProxySessionStatus {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.ProxySessionStatus
  ): zio.aws.chime.model.ProxySessionStatus = value match {
    case software.amazon.awssdk.services.chime.model.ProxySessionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.ProxySessionStatus.OPEN =>
      val r = Open
      r
    case software.amazon.awssdk.services.chime.model.ProxySessionStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.chime.model.ProxySessionStatus.CLOSED =>
      val r = Closed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.ProxySessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ProxySessionStatus =
      software.amazon.awssdk.services.chime.model.ProxySessionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Open extends zio.aws.chime.model.ProxySessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ProxySessionStatus =
      software.amazon.awssdk.services.chime.model.ProxySessionStatus.OPEN
  }
  case object InProgress extends zio.aws.chime.model.ProxySessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ProxySessionStatus =
      software.amazon.awssdk.services.chime.model.ProxySessionStatus.IN_PROGRESS
  }
  case object Closed extends zio.aws.chime.model.ProxySessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ProxySessionStatus =
      software.amazon.awssdk.services.chime.model.ProxySessionStatus.CLOSED
  }
}
