package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutAppInstanceRetentionSettingsRequest(
    appInstanceArn: ChimeArn,
    appInstanceRetentionSettings: zio.aws.chime.model.AppInstanceRetentionSettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutAppInstanceRetentionSettingsRequest = {
    import PutAppInstanceRetentionSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutAppInstanceRetentionSettingsRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .appInstanceRetentionSettings(
        appInstanceRetentionSettings.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutAppInstanceRetentionSettingsRequest.ReadOnly =
    zio.aws.chime.model.PutAppInstanceRetentionSettingsRequest
      .wrap(buildAwsValue())
}
object PutAppInstanceRetentionSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutAppInstanceRetentionSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PutAppInstanceRetentionSettingsRequest =
      zio.aws.chime.model.PutAppInstanceRetentionSettingsRequest(
        appInstanceArn,
        appInstanceRetentionSettings.asEditable
      )
    def appInstanceArn: ChimeArn
    def appInstanceRetentionSettings
        : zio.aws.chime.model.AppInstanceRetentionSettings.ReadOnly
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
    def getAppInstanceRetentionSettings: ZIO[
      Any,
      Nothing,
      zio.aws.chime.model.AppInstanceRetentionSettings.ReadOnly
    ] = ZIO.succeed(appInstanceRetentionSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutAppInstanceRetentionSettingsRequest
  ) extends zio.aws.chime.model.PutAppInstanceRetentionSettingsRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceArn())
    override val appInstanceRetentionSettings
        : zio.aws.chime.model.AppInstanceRetentionSettings.ReadOnly =
      zio.aws.chime.model.AppInstanceRetentionSettings
        .wrap(impl.appInstanceRetentionSettings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutAppInstanceRetentionSettingsRequest
  ): zio.aws.chime.model.PutAppInstanceRetentionSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
