package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class PutAppInstanceRetentionSettingsResponse(
    appInstanceRetentionSettings: Optional[
      zio.aws.chime.model.AppInstanceRetentionSettings
    ] = Optional.Absent,
    initiateDeletionTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutAppInstanceRetentionSettingsResponse = {
    import PutAppInstanceRetentionSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutAppInstanceRetentionSettingsResponse
      .builder()
      .optionallyWith(
        appInstanceRetentionSettings.map(value => value.buildAwsValue())
      )(_.appInstanceRetentionSettings)
      .optionallyWith(
        initiateDeletionTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.initiateDeletionTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutAppInstanceRetentionSettingsResponse.ReadOnly =
    zio.aws.chime.model.PutAppInstanceRetentionSettingsResponse
      .wrap(buildAwsValue())
}
object PutAppInstanceRetentionSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutAppInstanceRetentionSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.PutAppInstanceRetentionSettingsResponse =
      zio.aws.chime.model.PutAppInstanceRetentionSettingsResponse(
        appInstanceRetentionSettings.map(value => value.asEditable),
        initiateDeletionTimestamp.map(value => value)
      )
    def appInstanceRetentionSettings
        : Optional[zio.aws.chime.model.AppInstanceRetentionSettings.ReadOnly]
    def initiateDeletionTimestamp: Optional[Timestamp]
    def getAppInstanceRetentionSettings: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.AppInstanceRetentionSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "appInstanceRetentionSettings",
      appInstanceRetentionSettings
    )
    def getInitiateDeletionTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("initiateDeletionTimestamp", initiateDeletionTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutAppInstanceRetentionSettingsResponse
  ) extends zio.aws.chime.model.PutAppInstanceRetentionSettingsResponse.ReadOnly {
    override val appInstanceRetentionSettings
        : Optional[zio.aws.chime.model.AppInstanceRetentionSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appInstanceRetentionSettings())
        .map(value =>
          zio.aws.chime.model.AppInstanceRetentionSettings.wrap(value)
        )
    override val initiateDeletionTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initiateDeletionTimestamp())
        .map(value => zio.aws.chime.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutAppInstanceRetentionSettingsResponse
  ): zio.aws.chime.model.PutAppInstanceRetentionSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
