package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutAppInstanceStreamingConfigurationsRequest(
    appInstanceArn: ChimeArn,
    appInstanceStreamingConfigurations: Iterable[
      zio.aws.chime.model.AppInstanceStreamingConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutAppInstanceStreamingConfigurationsRequest = {
    import PutAppInstanceStreamingConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutAppInstanceStreamingConfigurationsRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .appInstanceStreamingConfigurations(
        appInstanceStreamingConfigurations.map { item =>
          item.buildAwsValue()
        }.asJavaCollection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutAppInstanceStreamingConfigurationsRequest.ReadOnly =
    zio.aws.chime.model.PutAppInstanceStreamingConfigurationsRequest
      .wrap(buildAwsValue())
}
object PutAppInstanceStreamingConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutAppInstanceStreamingConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.PutAppInstanceStreamingConfigurationsRequest =
      zio.aws.chime.model.PutAppInstanceStreamingConfigurationsRequest(
        appInstanceArn,
        appInstanceStreamingConfigurations.map { item =>
          item.asEditable
        }
      )
    def appInstanceArn: ChimeArn
    def appInstanceStreamingConfigurations
        : List[zio.aws.chime.model.AppInstanceStreamingConfiguration.ReadOnly]
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
    def getAppInstanceStreamingConfigurations: ZIO[Any, Nothing, List[
      zio.aws.chime.model.AppInstanceStreamingConfiguration.ReadOnly
    ]] = ZIO.succeed(appInstanceStreamingConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutAppInstanceStreamingConfigurationsRequest
  ) extends zio.aws.chime.model.PutAppInstanceStreamingConfigurationsRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceArn())
    override val appInstanceStreamingConfigurations
        : List[zio.aws.chime.model.AppInstanceStreamingConfiguration.ReadOnly] =
      impl
        .appInstanceStreamingConfigurations()
        .asScala
        .map { item =>
          zio.aws.chime.model.AppInstanceStreamingConfiguration.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutAppInstanceStreamingConfigurationsRequest
  ): zio.aws.chime.model.PutAppInstanceStreamingConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
