package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutAppInstanceStreamingConfigurationsResponse(
    appInstanceStreamingConfigurations: Optional[
      Iterable[zio.aws.chime.model.AppInstanceStreamingConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutAppInstanceStreamingConfigurationsResponse = {
    import PutAppInstanceStreamingConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutAppInstanceStreamingConfigurationsResponse
      .builder()
      .optionallyWith(
        appInstanceStreamingConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appInstanceStreamingConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutAppInstanceStreamingConfigurationsResponse.ReadOnly =
    zio.aws.chime.model.PutAppInstanceStreamingConfigurationsResponse
      .wrap(buildAwsValue())
}
object PutAppInstanceStreamingConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutAppInstanceStreamingConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.PutAppInstanceStreamingConfigurationsResponse =
      zio.aws.chime.model.PutAppInstanceStreamingConfigurationsResponse(
        appInstanceStreamingConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def appInstanceStreamingConfigurations: Optional[
      List[zio.aws.chime.model.AppInstanceStreamingConfiguration.ReadOnly]
    ]
    def getAppInstanceStreamingConfigurations: ZIO[Any, AwsError, List[
      zio.aws.chime.model.AppInstanceStreamingConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "appInstanceStreamingConfigurations",
      appInstanceStreamingConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutAppInstanceStreamingConfigurationsResponse
  ) extends zio.aws.chime.model.PutAppInstanceStreamingConfigurationsResponse.ReadOnly {
    override val appInstanceStreamingConfigurations: Optional[
      List[zio.aws.chime.model.AppInstanceStreamingConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceStreamingConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chime.model.AppInstanceStreamingConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutAppInstanceStreamingConfigurationsResponse
  ): zio.aws.chime.model.PutAppInstanceStreamingConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
