package zio.aws.chime.model
import zio.aws.chime.model.primitives.{SensitiveString, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutEventsConfigurationRequest(
    accountId: NonEmptyString,
    botId: NonEmptyString,
    outboundEventsHTTPSEndpoint: Optional[SensitiveString] = Optional.Absent,
    lambdaFunctionArn: Optional[SensitiveString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutEventsConfigurationRequest = {
    import PutEventsConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutEventsConfigurationRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .botId(NonEmptyString.unwrap(botId): java.lang.String)
      .optionallyWith(
        outboundEventsHTTPSEndpoint.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.outboundEventsHTTPSEndpoint)
      .optionallyWith(
        lambdaFunctionArn.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.lambdaFunctionArn)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.PutEventsConfigurationRequest.ReadOnly =
    zio.aws.chime.model.PutEventsConfigurationRequest.wrap(buildAwsValue())
}
object PutEventsConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutEventsConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PutEventsConfigurationRequest =
      zio.aws.chime.model.PutEventsConfigurationRequest(
        accountId,
        botId,
        outboundEventsHTTPSEndpoint.map(value => value),
        lambdaFunctionArn.map(value => value)
      )
    def accountId: NonEmptyString
    def botId: NonEmptyString
    def outboundEventsHTTPSEndpoint: Optional[SensitiveString]
    def lambdaFunctionArn: Optional[SensitiveString]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getBotId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(botId)
    def getOutboundEventsHTTPSEndpoint: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField(
        "outboundEventsHTTPSEndpoint",
        outboundEventsHTTPSEndpoint
      )
    def getLambdaFunctionArn: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("lambdaFunctionArn", lambdaFunctionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutEventsConfigurationRequest
  ) extends zio.aws.chime.model.PutEventsConfigurationRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val botId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.botId())
    override val outboundEventsHTTPSEndpoint: Optional[SensitiveString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outboundEventsHTTPSEndpoint())
        .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
    override val lambdaFunctionArn: Optional[SensitiveString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaFunctionArn())
        .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutEventsConfigurationRequest
  ): zio.aws.chime.model.PutEventsConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
