package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutEventsConfigurationResponse(
    eventsConfiguration: Optional[zio.aws.chime.model.EventsConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutEventsConfigurationResponse = {
    import PutEventsConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutEventsConfigurationResponse
      .builder()
      .optionallyWith(eventsConfiguration.map(value => value.buildAwsValue()))(
        _.eventsConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.PutEventsConfigurationResponse.ReadOnly =
    zio.aws.chime.model.PutEventsConfigurationResponse.wrap(buildAwsValue())
}
object PutEventsConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutEventsConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PutEventsConfigurationResponse =
      zio.aws.chime.model.PutEventsConfigurationResponse(
        eventsConfiguration.map(value => value.asEditable)
      )
    def eventsConfiguration
        : Optional[zio.aws.chime.model.EventsConfiguration.ReadOnly]
    def getEventsConfiguration
        : ZIO[Any, AwsError, zio.aws.chime.model.EventsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("eventsConfiguration", eventsConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutEventsConfigurationResponse
  ) extends zio.aws.chime.model.PutEventsConfigurationResponse.ReadOnly {
    override val eventsConfiguration
        : Optional[zio.aws.chime.model.EventsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventsConfiguration())
        .map(value => zio.aws.chime.model.EventsConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutEventsConfigurationResponse
  ): zio.aws.chime.model.PutEventsConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
