package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutRetentionSettingsRequest(
    accountId: NonEmptyString,
    retentionSettings: zio.aws.chime.model.RetentionSettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutRetentionSettingsRequest = {
    import PutRetentionSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutRetentionSettingsRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .retentionSettings(retentionSettings.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.chime.model.PutRetentionSettingsRequest.ReadOnly =
    zio.aws.chime.model.PutRetentionSettingsRequest.wrap(buildAwsValue())
}
object PutRetentionSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutRetentionSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PutRetentionSettingsRequest =
      zio.aws.chime.model
        .PutRetentionSettingsRequest(accountId, retentionSettings.asEditable)
    def accountId: NonEmptyString
    def retentionSettings: zio.aws.chime.model.RetentionSettings.ReadOnly
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getRetentionSettings
        : ZIO[Any, Nothing, zio.aws.chime.model.RetentionSettings.ReadOnly] =
      ZIO.succeed(retentionSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutRetentionSettingsRequest
  ) extends zio.aws.chime.model.PutRetentionSettingsRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val retentionSettings
        : zio.aws.chime.model.RetentionSettings.ReadOnly =
      zio.aws.chime.model.RetentionSettings.wrap(impl.retentionSettings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutRetentionSettingsRequest
  ): zio.aws.chime.model.PutRetentionSettingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
