package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutSipMediaApplicationLoggingConfigurationRequest(
    sipMediaApplicationId: NonEmptyString,
    sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chime.model.SipMediaApplicationLoggingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutSipMediaApplicationLoggingConfigurationRequest = {
    import PutSipMediaApplicationLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutSipMediaApplicationLoggingConfigurationRequest
      .builder()
      .sipMediaApplicationId(
        NonEmptyString.unwrap(sipMediaApplicationId): java.lang.String
      )
      .optionallyWith(
        sipMediaApplicationLoggingConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.sipMediaApplicationLoggingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationRequest.ReadOnly =
    zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationRequest
      .wrap(buildAwsValue())
}
object PutSipMediaApplicationLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutSipMediaApplicationLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationRequest =
      zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationRequest(
        sipMediaApplicationId,
        sipMediaApplicationLoggingConfiguration.map(value => value.asEditable)
      )
    def sipMediaApplicationId: NonEmptyString
    def sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chime.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ]
    def getSipMediaApplicationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(sipMediaApplicationId)
    def getSipMediaApplicationLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sipMediaApplicationLoggingConfiguration",
      sipMediaApplicationLoggingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutSipMediaApplicationLoggingConfigurationRequest
  ) extends zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationRequest.ReadOnly {
    override val sipMediaApplicationId: NonEmptyString =
      zio.aws.chime.model.primitives
        .NonEmptyString(impl.sipMediaApplicationId())
    override val sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chime.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sipMediaApplicationLoggingConfiguration())
      .map(value =>
        zio.aws.chime.model.SipMediaApplicationLoggingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutSipMediaApplicationLoggingConfigurationRequest
  ): zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
