package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutSipMediaApplicationLoggingConfigurationResponse(
    sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chime.model.SipMediaApplicationLoggingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutSipMediaApplicationLoggingConfigurationResponse = {
    import PutSipMediaApplicationLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutSipMediaApplicationLoggingConfigurationResponse
      .builder()
      .optionallyWith(
        sipMediaApplicationLoggingConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.sipMediaApplicationLoggingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly =
    zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object PutSipMediaApplicationLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutSipMediaApplicationLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationResponse =
      zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationResponse(
        sipMediaApplicationLoggingConfiguration.map(value => value.asEditable)
      )
    def sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chime.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ]
    def getSipMediaApplicationLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sipMediaApplicationLoggingConfiguration",
      sipMediaApplicationLoggingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutSipMediaApplicationLoggingConfigurationResponse
  ) extends zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly {
    override val sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chime.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sipMediaApplicationLoggingConfiguration())
      .map(value =>
        zio.aws.chime.model.SipMediaApplicationLoggingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutSipMediaApplicationLoggingConfigurationResponse
  ): zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
