package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorEmergencyCallingConfigurationRequest(
    voiceConnectorId: NonEmptyString,
    emergencyCallingConfiguration: zio.aws.chime.model.EmergencyCallingConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest = {
    import PutVoiceConnectorEmergencyCallingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .emergencyCallingConfiguration(
        emergencyCallingConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest.ReadOnly =
    zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest
      .wrap(buildAwsValue())
}
object PutVoiceConnectorEmergencyCallingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest =
      zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest(
        voiceConnectorId,
        emergencyCallingConfiguration.asEditable
      )
    def voiceConnectorId: NonEmptyString
    def emergencyCallingConfiguration
        : zio.aws.chime.model.EmergencyCallingConfiguration.ReadOnly
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getEmergencyCallingConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chime.model.EmergencyCallingConfiguration.ReadOnly
    ] = ZIO.succeed(emergencyCallingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest
  ) extends zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
    override val emergencyCallingConfiguration
        : zio.aws.chime.model.EmergencyCallingConfiguration.ReadOnly =
      zio.aws.chime.model.EmergencyCallingConfiguration
        .wrap(impl.emergencyCallingConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest
  ): zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
