package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorEmergencyCallingConfigurationResponse(
    emergencyCallingConfiguration: Optional[
      zio.aws.chime.model.EmergencyCallingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse = {
    import PutVoiceConnectorEmergencyCallingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse
      .builder()
      .optionallyWith(
        emergencyCallingConfiguration.map(value => value.buildAwsValue())
      )(_.emergencyCallingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly =
    zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse
      .wrap(buildAwsValue())
}
object PutVoiceConnectorEmergencyCallingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse =
      zio.aws.chime.model
        .PutVoiceConnectorEmergencyCallingConfigurationResponse(
          emergencyCallingConfiguration.map(value => value.asEditable)
        )
    def emergencyCallingConfiguration
        : Optional[zio.aws.chime.model.EmergencyCallingConfiguration.ReadOnly]
    def getEmergencyCallingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.EmergencyCallingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "emergencyCallingConfiguration",
      emergencyCallingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse
  ) extends zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly {
    override val emergencyCallingConfiguration
        : Optional[zio.aws.chime.model.EmergencyCallingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emergencyCallingConfiguration())
        .map(value =>
          zio.aws.chime.model.EmergencyCallingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse
  ): zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
