package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorLoggingConfigurationRequest(
    voiceConnectorId: NonEmptyString,
    loggingConfiguration: zio.aws.chime.model.LoggingConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationRequest = {
    import PutVoiceConnectorLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .loggingConfiguration(loggingConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationRequest.ReadOnly =
    zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationRequest
      .wrap(buildAwsValue())
}
object PutVoiceConnectorLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationRequest =
      zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationRequest(
        voiceConnectorId,
        loggingConfiguration.asEditable
      )
    def voiceConnectorId: NonEmptyString
    def loggingConfiguration: zio.aws.chime.model.LoggingConfiguration.ReadOnly
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getLoggingConfiguration
        : ZIO[Any, Nothing, zio.aws.chime.model.LoggingConfiguration.ReadOnly] =
      ZIO.succeed(loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationRequest
  ) extends zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
    override val loggingConfiguration
        : zio.aws.chime.model.LoggingConfiguration.ReadOnly =
      zio.aws.chime.model.LoggingConfiguration.wrap(impl.loggingConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationRequest
  ): zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
