package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorLoggingConfigurationResponse(
    loggingConfiguration: Optional[zio.aws.chime.model.LoggingConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationResponse = {
    import PutVoiceConnectorLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationResponse
      .builder()
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly =
    zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object PutVoiceConnectorLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationResponse =
      zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationResponse(
        loggingConfiguration.map(value => value.asEditable)
      )
    def loggingConfiguration
        : Optional[zio.aws.chime.model.LoggingConfiguration.ReadOnly]
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.LoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationResponse
  ) extends zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly {
    override val loggingConfiguration
        : Optional[zio.aws.chime.model.LoggingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfiguration())
        .map(value => zio.aws.chime.model.LoggingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationResponse
  ): zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
