package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorOriginationRequest(
    voiceConnectorId: NonEmptyString,
    origination: zio.aws.chime.model.Origination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationRequest = {
    import PutVoiceConnectorOriginationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .origination(origination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutVoiceConnectorOriginationRequest.ReadOnly =
    zio.aws.chime.model.PutVoiceConnectorOriginationRequest
      .wrap(buildAwsValue())
}
object PutVoiceConnectorOriginationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PutVoiceConnectorOriginationRequest =
      zio.aws.chime.model.PutVoiceConnectorOriginationRequest(
        voiceConnectorId,
        origination.asEditable
      )
    def voiceConnectorId: NonEmptyString
    def origination: zio.aws.chime.model.Origination.ReadOnly
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getOrigination
        : ZIO[Any, Nothing, zio.aws.chime.model.Origination.ReadOnly] =
      ZIO.succeed(origination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationRequest
  ) extends zio.aws.chime.model.PutVoiceConnectorOriginationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
    override val origination: zio.aws.chime.model.Origination.ReadOnly =
      zio.aws.chime.model.Origination.wrap(impl.origination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationRequest
  ): zio.aws.chime.model.PutVoiceConnectorOriginationRequest.ReadOnly =
    new Wrapper(impl)
}
