package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorOriginationResponse(
    origination: Optional[zio.aws.chime.model.Origination] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationResponse = {
    import PutVoiceConnectorOriginationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationResponse
      .builder()
      .optionallyWith(origination.map(value => value.buildAwsValue()))(
        _.origination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutVoiceConnectorOriginationResponse.ReadOnly =
    zio.aws.chime.model.PutVoiceConnectorOriginationResponse
      .wrap(buildAwsValue())
}
object PutVoiceConnectorOriginationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PutVoiceConnectorOriginationResponse =
      zio.aws.chime.model.PutVoiceConnectorOriginationResponse(
        origination.map(value => value.asEditable)
      )
    def origination: Optional[zio.aws.chime.model.Origination.ReadOnly]
    def getOrigination
        : ZIO[Any, AwsError, zio.aws.chime.model.Origination.ReadOnly] =
      AwsError.unwrapOptionField("origination", origination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationResponse
  ) extends zio.aws.chime.model.PutVoiceConnectorOriginationResponse.ReadOnly {
    override val origination
        : Optional[zio.aws.chime.model.Origination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.origination())
        .map(value => zio.aws.chime.model.Origination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationResponse
  ): zio.aws.chime.model.PutVoiceConnectorOriginationResponse.ReadOnly =
    new Wrapper(impl)
}
