package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorProxyResponse(
    proxy: Optional[zio.aws.chime.model.Proxy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutVoiceConnectorProxyResponse = {
    import PutVoiceConnectorProxyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorProxyResponse
      .builder()
      .optionallyWith(proxy.map(value => value.buildAwsValue()))(_.proxy)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.PutVoiceConnectorProxyResponse.ReadOnly =
    zio.aws.chime.model.PutVoiceConnectorProxyResponse.wrap(buildAwsValue())
}
object PutVoiceConnectorProxyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorProxyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PutVoiceConnectorProxyResponse =
      zio.aws.chime.model
        .PutVoiceConnectorProxyResponse(proxy.map(value => value.asEditable))
    def proxy: Optional[zio.aws.chime.model.Proxy.ReadOnly]
    def getProxy: ZIO[Any, AwsError, zio.aws.chime.model.Proxy.ReadOnly] =
      AwsError.unwrapOptionField("proxy", proxy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorProxyResponse
  ) extends zio.aws.chime.model.PutVoiceConnectorProxyResponse.ReadOnly {
    override val proxy: Optional[zio.aws.chime.model.Proxy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxy())
        .map(value => zio.aws.chime.model.Proxy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorProxyResponse
  ): zio.aws.chime.model.PutVoiceConnectorProxyResponse.ReadOnly = new Wrapper(
    impl
  )
}
