package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorStreamingConfigurationRequest(
    voiceConnectorId: NonEmptyString,
    streamingConfiguration: zio.aws.chime.model.StreamingConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationRequest = {
    import PutVoiceConnectorStreamingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .streamingConfiguration(streamingConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationRequest.ReadOnly =
    zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationRequest
      .wrap(buildAwsValue())
}
object PutVoiceConnectorStreamingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationRequest =
      zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationRequest(
        voiceConnectorId,
        streamingConfiguration.asEditable
      )
    def voiceConnectorId: NonEmptyString
    def streamingConfiguration
        : zio.aws.chime.model.StreamingConfiguration.ReadOnly
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getStreamingConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chime.model.StreamingConfiguration.ReadOnly
    ] = ZIO.succeed(streamingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationRequest
  ) extends zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
    override val streamingConfiguration
        : zio.aws.chime.model.StreamingConfiguration.ReadOnly =
      zio.aws.chime.model.StreamingConfiguration
        .wrap(impl.streamingConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationRequest
  ): zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
