package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorStreamingConfigurationResponse(
    streamingConfiguration: Optional[
      zio.aws.chime.model.StreamingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationResponse = {
    import PutVoiceConnectorStreamingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationResponse
      .builder()
      .optionallyWith(
        streamingConfiguration.map(value => value.buildAwsValue())
      )(_.streamingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationResponse.ReadOnly =
    zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationResponse
      .wrap(buildAwsValue())
}
object PutVoiceConnectorStreamingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationResponse =
      zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationResponse(
        streamingConfiguration.map(value => value.asEditable)
      )
    def streamingConfiguration
        : Optional[zio.aws.chime.model.StreamingConfiguration.ReadOnly]
    def getStreamingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.StreamingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "streamingConfiguration",
      streamingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationResponse
  ) extends zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationResponse.ReadOnly {
    override val streamingConfiguration
        : Optional[zio.aws.chime.model.StreamingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamingConfiguration())
        .map(value => zio.aws.chime.model.StreamingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationResponse
  ): zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
