package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorTerminationCredentialsRequest(
    voiceConnectorId: NonEmptyString,
    credentials: Optional[Iterable[zio.aws.chime.model.Credential]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationCredentialsRequest = {
    import PutVoiceConnectorTerminationCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationCredentialsRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .optionallyWith(
        credentials.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.credentials)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutVoiceConnectorTerminationCredentialsRequest.ReadOnly =
    zio.aws.chime.model.PutVoiceConnectorTerminationCredentialsRequest
      .wrap(buildAwsValue())
}
object PutVoiceConnectorTerminationCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.PutVoiceConnectorTerminationCredentialsRequest =
      zio.aws.chime.model.PutVoiceConnectorTerminationCredentialsRequest(
        voiceConnectorId,
        credentials.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def voiceConnectorId: NonEmptyString
    def credentials: Optional[List[zio.aws.chime.model.Credential.ReadOnly]]
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getCredentials
        : ZIO[Any, AwsError, List[zio.aws.chime.model.Credential.ReadOnly]] =
      AwsError.unwrapOptionField("credentials", credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationCredentialsRequest
  ) extends zio.aws.chime.model.PutVoiceConnectorTerminationCredentialsRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
    override val credentials
        : Optional[List[zio.aws.chime.model.Credential.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Credential.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationCredentialsRequest
  ): zio.aws.chime.model.PutVoiceConnectorTerminationCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
