package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorTerminationRequest(
    voiceConnectorId: NonEmptyString,
    termination: zio.aws.chime.model.Termination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationRequest = {
    import PutVoiceConnectorTerminationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .termination(termination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutVoiceConnectorTerminationRequest.ReadOnly =
    zio.aws.chime.model.PutVoiceConnectorTerminationRequest
      .wrap(buildAwsValue())
}
object PutVoiceConnectorTerminationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PutVoiceConnectorTerminationRequest =
      zio.aws.chime.model.PutVoiceConnectorTerminationRequest(
        voiceConnectorId,
        termination.asEditable
      )
    def voiceConnectorId: NonEmptyString
    def termination: zio.aws.chime.model.Termination.ReadOnly
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getTermination
        : ZIO[Any, Nothing, zio.aws.chime.model.Termination.ReadOnly] =
      ZIO.succeed(termination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationRequest
  ) extends zio.aws.chime.model.PutVoiceConnectorTerminationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
    override val termination: zio.aws.chime.model.Termination.ReadOnly =
      zio.aws.chime.model.Termination.wrap(impl.termination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationRequest
  ): zio.aws.chime.model.PutVoiceConnectorTerminationRequest.ReadOnly =
    new Wrapper(impl)
}
