package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorTerminationResponse(
    termination: Optional[zio.aws.chime.model.Termination] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationResponse = {
    import PutVoiceConnectorTerminationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationResponse
      .builder()
      .optionallyWith(termination.map(value => value.buildAwsValue()))(
        _.termination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.PutVoiceConnectorTerminationResponse.ReadOnly =
    zio.aws.chime.model.PutVoiceConnectorTerminationResponse
      .wrap(buildAwsValue())
}
object PutVoiceConnectorTerminationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.PutVoiceConnectorTerminationResponse =
      zio.aws.chime.model.PutVoiceConnectorTerminationResponse(
        termination.map(value => value.asEditable)
      )
    def termination: Optional[zio.aws.chime.model.Termination.ReadOnly]
    def getTermination
        : ZIO[Any, AwsError, zio.aws.chime.model.Termination.ReadOnly] =
      AwsError.unwrapOptionField("termination", termination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationResponse
  ) extends zio.aws.chime.model.PutVoiceConnectorTerminationResponse.ReadOnly {
    override val termination
        : Optional[zio.aws.chime.model.Termination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.termination())
        .map(value => zio.aws.chime.model.Termination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationResponse
  ): zio.aws.chime.model.PutVoiceConnectorTerminationResponse.ReadOnly =
    new Wrapper(impl)
}
