package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RedactConversationMessageRequest(
    accountId: NonEmptyString,
    conversationId: NonEmptyString,
    messageId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.RedactConversationMessageRequest = {
    import RedactConversationMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.RedactConversationMessageRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .conversationId(NonEmptyString.unwrap(conversationId): java.lang.String)
      .messageId(NonEmptyString.unwrap(messageId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.RedactConversationMessageRequest.ReadOnly =
    zio.aws.chime.model.RedactConversationMessageRequest.wrap(buildAwsValue())
}
object RedactConversationMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.RedactConversationMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.RedactConversationMessageRequest =
      zio.aws.chime.model
        .RedactConversationMessageRequest(accountId, conversationId, messageId)
    def accountId: NonEmptyString
    def conversationId: NonEmptyString
    def messageId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getConversationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(conversationId)
    def getMessageId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.RedactConversationMessageRequest
  ) extends zio.aws.chime.model.RedactConversationMessageRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val conversationId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.conversationId())
    override val messageId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.messageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.RedactConversationMessageRequest
  ): zio.aws.chime.model.RedactConversationMessageRequest.ReadOnly =
    new Wrapper(impl)
}
