package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RedactRoomMessageRequest(
    accountId: NonEmptyString,
    roomId: NonEmptyString,
    messageId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.RedactRoomMessageRequest = {
    import RedactRoomMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.RedactRoomMessageRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .roomId(NonEmptyString.unwrap(roomId): java.lang.String)
      .messageId(NonEmptyString.unwrap(messageId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.RedactRoomMessageRequest.ReadOnly =
    zio.aws.chime.model.RedactRoomMessageRequest.wrap(buildAwsValue())
}
object RedactRoomMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.RedactRoomMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.RedactRoomMessageRequest =
      zio.aws.chime.model.RedactRoomMessageRequest(accountId, roomId, messageId)
    def accountId: NonEmptyString
    def roomId: NonEmptyString
    def messageId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getRoomId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(roomId)
    def getMessageId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.RedactRoomMessageRequest
  ) extends zio.aws.chime.model.RedactRoomMessageRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val roomId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.roomId())
    override val messageId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.messageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.RedactRoomMessageRequest
  ): zio.aws.chime.model.RedactRoomMessageRequest.ReadOnly = new Wrapper(impl)
}
