package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RegenerateSecurityTokenRequest(
    accountId: NonEmptyString,
    botId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.RegenerateSecurityTokenRequest = {
    import RegenerateSecurityTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.RegenerateSecurityTokenRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .botId(NonEmptyString.unwrap(botId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.RegenerateSecurityTokenRequest.ReadOnly =
    zio.aws.chime.model.RegenerateSecurityTokenRequest.wrap(buildAwsValue())
}
object RegenerateSecurityTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.RegenerateSecurityTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.RegenerateSecurityTokenRequest =
      zio.aws.chime.model.RegenerateSecurityTokenRequest(accountId, botId)
    def accountId: NonEmptyString
    def botId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getBotId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(botId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.RegenerateSecurityTokenRequest
  ) extends zio.aws.chime.model.RegenerateSecurityTokenRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val botId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.botId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.RegenerateSecurityTokenRequest
  ): zio.aws.chime.model.RegenerateSecurityTokenRequest.ReadOnly = new Wrapper(
    impl
  )
}
