package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait RegistrationStatus {
  def unwrap: software.amazon.awssdk.services.chime.model.RegistrationStatus
}
object RegistrationStatus {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.RegistrationStatus
  ): zio.aws.chime.model.RegistrationStatus = value match {
    case software.amazon.awssdk.services.chime.model.RegistrationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.RegistrationStatus.UNREGISTERED =>
      val r = Unregistered
      r
    case software.amazon.awssdk.services.chime.model.RegistrationStatus.REGISTERED =>
      val r = Registered
      r
    case software.amazon.awssdk.services.chime.model.RegistrationStatus.SUSPENDED =>
      val r = Suspended
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.RegistrationStatus =
      software.amazon.awssdk.services.chime.model.RegistrationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Unregistered extends zio.aws.chime.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.RegistrationStatus =
      software.amazon.awssdk.services.chime.model.RegistrationStatus.UNREGISTERED
  }
  case object Registered extends zio.aws.chime.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.RegistrationStatus =
      software.amazon.awssdk.services.chime.model.RegistrationStatus.REGISTERED
  }
  case object Suspended extends zio.aws.chime.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.RegistrationStatus =
      software.amazon.awssdk.services.chime.model.RegistrationStatus.SUSPENDED
  }
}
