package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResetPersonalPinRequest(
    accountId: NonEmptyString,
    userId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ResetPersonalPinRequest = {
    import ResetPersonalPinRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ResetPersonalPinRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .userId(NonEmptyString.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ResetPersonalPinRequest.ReadOnly =
    zio.aws.chime.model.ResetPersonalPinRequest.wrap(buildAwsValue())
}
object ResetPersonalPinRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ResetPersonalPinRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ResetPersonalPinRequest =
      zio.aws.chime.model.ResetPersonalPinRequest(accountId, userId)
    def accountId: NonEmptyString
    def userId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getUserId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ResetPersonalPinRequest
  ) extends zio.aws.chime.model.ResetPersonalPinRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val userId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ResetPersonalPinRequest
  ): zio.aws.chime.model.ResetPersonalPinRequest.ReadOnly = new Wrapper(impl)
}
