package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResetPersonalPinResponse(
    user: Optional[zio.aws.chime.model.User] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ResetPersonalPinResponse = {
    import ResetPersonalPinResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ResetPersonalPinResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ResetPersonalPinResponse.ReadOnly =
    zio.aws.chime.model.ResetPersonalPinResponse.wrap(buildAwsValue())
}
object ResetPersonalPinResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ResetPersonalPinResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ResetPersonalPinResponse =
      zio.aws.chime.model
        .ResetPersonalPinResponse(user.map(value => value.asEditable))
    def user: Optional[zio.aws.chime.model.User.ReadOnly]
    def getUser: ZIO[Any, AwsError, zio.aws.chime.model.User.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ResetPersonalPinResponse
  ) extends zio.aws.chime.model.ResetPersonalPinResponse.ReadOnly {
    override val user: Optional[zio.aws.chime.model.User.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.user())
        .map(value => zio.aws.chime.model.User.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ResetPersonalPinResponse
  ): zio.aws.chime.model.ResetPersonalPinResponse.ReadOnly = new Wrapper(impl)
}
