package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RestorePhoneNumberRequest(phoneNumberId: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.RestorePhoneNumberRequest = {
    import RestorePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.RestorePhoneNumberRequest
      .builder()
      .phoneNumberId(NonEmptyString.unwrap(phoneNumberId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.RestorePhoneNumberRequest.ReadOnly =
    zio.aws.chime.model.RestorePhoneNumberRequest.wrap(buildAwsValue())
}
object RestorePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.RestorePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.RestorePhoneNumberRequest =
      zio.aws.chime.model.RestorePhoneNumberRequest(phoneNumberId)
    def phoneNumberId: NonEmptyString
    def getPhoneNumberId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(phoneNumberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.RestorePhoneNumberRequest
  ) extends zio.aws.chime.model.RestorePhoneNumberRequest.ReadOnly {
    override val phoneNumberId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.phoneNumberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.RestorePhoneNumberRequest
  ): zio.aws.chime.model.RestorePhoneNumberRequest.ReadOnly = new Wrapper(impl)
}
