package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RetentionSettings(
    roomRetentionSettings: Optional[zio.aws.chime.model.RoomRetentionSettings] =
      Optional.Absent,
    conversationRetentionSettings: Optional[
      zio.aws.chime.model.ConversationRetentionSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.RetentionSettings = {
    import RetentionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.RetentionSettings
      .builder()
      .optionallyWith(
        roomRetentionSettings.map(value => value.buildAwsValue())
      )(_.roomRetentionSettings)
      .optionallyWith(
        conversationRetentionSettings.map(value => value.buildAwsValue())
      )(_.conversationRetentionSettings)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.RetentionSettings.ReadOnly =
    zio.aws.chime.model.RetentionSettings.wrap(buildAwsValue())
}
object RetentionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.RetentionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.RetentionSettings =
      zio.aws.chime.model.RetentionSettings(
        roomRetentionSettings.map(value => value.asEditable),
        conversationRetentionSettings.map(value => value.asEditable)
      )
    def roomRetentionSettings
        : Optional[zio.aws.chime.model.RoomRetentionSettings.ReadOnly]
    def conversationRetentionSettings
        : Optional[zio.aws.chime.model.ConversationRetentionSettings.ReadOnly]
    def getRoomRetentionSettings: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.RoomRetentionSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("roomRetentionSettings", roomRetentionSettings)
    def getConversationRetentionSettings: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.ConversationRetentionSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "conversationRetentionSettings",
      conversationRetentionSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.RetentionSettings
  ) extends zio.aws.chime.model.RetentionSettings.ReadOnly {
    override val roomRetentionSettings
        : Optional[zio.aws.chime.model.RoomRetentionSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roomRetentionSettings())
        .map(value => zio.aws.chime.model.RoomRetentionSettings.wrap(value))
    override val conversationRetentionSettings
        : Optional[zio.aws.chime.model.ConversationRetentionSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversationRetentionSettings())
        .map(value =>
          zio.aws.chime.model.ConversationRetentionSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.RetentionSettings
  ): zio.aws.chime.model.RetentionSettings.ReadOnly = new Wrapper(impl)
}
