package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  Iso8601Timestamp,
  SensitiveString,
  NonEmptyString
}
import scala.jdk.CollectionConverters._
final case class Room(
    roomId: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[SensitiveString] = Optional.Absent,
    accountId: Optional[NonEmptyString] = Optional.Absent,
    createdBy: Optional[NonEmptyString] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.chime.model.Room = {
    import Room.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.Room
      .builder()
      .optionallyWith(
        roomId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roomId)
      .optionallyWith(
        name.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        accountId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        createdBy.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.Room.ReadOnly =
    zio.aws.chime.model.Room.wrap(buildAwsValue())
}
object Room {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.Room] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.Room = zio.aws.chime.model.Room(
      roomId.map(value => value),
      name.map(value => value),
      accountId.map(value => value),
      createdBy.map(value => value),
      createdTimestamp.map(value => value),
      updatedTimestamp.map(value => value)
    )
    def roomId: Optional[NonEmptyString]
    def name: Optional[SensitiveString]
    def accountId: Optional[NonEmptyString]
    def createdBy: Optional[NonEmptyString]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def getRoomId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roomId", roomId)
    def getName: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("name", name)
    def getAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCreatedBy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.Room
  ) extends zio.aws.chime.model.Room.ReadOnly {
    override val roomId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roomId())
      .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
    override val name: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
    override val accountId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
    override val createdBy: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.Room
  ): zio.aws.chime.model.Room.ReadOnly = new Wrapper(impl)
}
