package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{Iso8601Timestamp, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class RoomMembership(
    roomId: Optional[NonEmptyString] = Optional.Absent,
    member: Optional[zio.aws.chime.model.Member] = Optional.Absent,
    role: Optional[zio.aws.chime.model.RoomMembershipRole] = Optional.Absent,
    invitedBy: Optional[NonEmptyString] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.RoomMembership = {
    import RoomMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.RoomMembership
      .builder()
      .optionallyWith(
        roomId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roomId)
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .optionallyWith(role.map(value => value.unwrap))(_.role)
      .optionallyWith(
        invitedBy.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.invitedBy)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.RoomMembership.ReadOnly =
    zio.aws.chime.model.RoomMembership.wrap(buildAwsValue())
}
object RoomMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.RoomMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.RoomMembership =
      zio.aws.chime.model.RoomMembership(
        roomId.map(value => value),
        member.map(value => value.asEditable),
        role.map(value => value),
        invitedBy.map(value => value),
        updatedTimestamp.map(value => value)
      )
    def roomId: Optional[NonEmptyString]
    def member: Optional[zio.aws.chime.model.Member.ReadOnly]
    def role: Optional[zio.aws.chime.model.RoomMembershipRole]
    def invitedBy: Optional[NonEmptyString]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def getRoomId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roomId", roomId)
    def getMember: ZIO[Any, AwsError, zio.aws.chime.model.Member.ReadOnly] =
      AwsError.unwrapOptionField("member", member)
    def getRole: ZIO[Any, AwsError, zio.aws.chime.model.RoomMembershipRole] =
      AwsError.unwrapOptionField("role", role)
    def getInvitedBy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("invitedBy", invitedBy)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.RoomMembership
  ) extends zio.aws.chime.model.RoomMembership.ReadOnly {
    override val roomId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roomId())
      .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
    override val member: Optional[zio.aws.chime.model.Member.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.member())
        .map(value => zio.aws.chime.model.Member.wrap(value))
    override val role: Optional[zio.aws.chime.model.RoomMembershipRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.role())
        .map(value => zio.aws.chime.model.RoomMembershipRole.wrap(value))
    override val invitedBy: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.invitedBy())
      .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.RoomMembership
  ): zio.aws.chime.model.RoomMembership.ReadOnly = new Wrapper(impl)
}
