package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait RoomMembershipRole {
  def unwrap: software.amazon.awssdk.services.chime.model.RoomMembershipRole
}
object RoomMembershipRole {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.RoomMembershipRole
  ): zio.aws.chime.model.RoomMembershipRole = value match {
    case software.amazon.awssdk.services.chime.model.RoomMembershipRole.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.RoomMembershipRole.ADMINISTRATOR =>
      val r = Administrator
      r
    case software.amazon.awssdk.services.chime.model.RoomMembershipRole.MEMBER =>
      val r = Member
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.RoomMembershipRole {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.RoomMembershipRole =
      software.amazon.awssdk.services.chime.model.RoomMembershipRole.UNKNOWN_TO_SDK_VERSION
  }
  case object Administrator extends zio.aws.chime.model.RoomMembershipRole {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.RoomMembershipRole =
      software.amazon.awssdk.services.chime.model.RoomMembershipRole.ADMINISTRATOR
  }
  case object Member extends zio.aws.chime.model.RoomMembershipRole {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.RoomMembershipRole =
      software.amazon.awssdk.services.chime.model.RoomMembershipRole.MEMBER
  }
}
