package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.RetentionDays
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RoomRetentionSettings(
    retentionDays: Optional[RetentionDays] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.RoomRetentionSettings = {
    import RoomRetentionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.RoomRetentionSettings
      .builder()
      .optionallyWith(
        retentionDays.map(value => RetentionDays.unwrap(value): Integer)
      )(_.retentionDays)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.RoomRetentionSettings.ReadOnly =
    zio.aws.chime.model.RoomRetentionSettings.wrap(buildAwsValue())
}
object RoomRetentionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.RoomRetentionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.RoomRetentionSettings =
      zio.aws.chime.model
        .RoomRetentionSettings(retentionDays.map(value => value))
    def retentionDays: Optional[RetentionDays]
    def getRetentionDays: ZIO[Any, AwsError, RetentionDays] =
      AwsError.unwrapOptionField("retentionDays", retentionDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.RoomRetentionSettings
  ) extends zio.aws.chime.model.RoomRetentionSettings.ReadOnly {
    override val retentionDays: Optional[RetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionDays())
      .map(value => zio.aws.chime.model.primitives.RetentionDays(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.RoomRetentionSettings
  ): zio.aws.chime.model.RoomRetentionSettings.ReadOnly = new Wrapper(impl)
}
