package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  PhoneNumberMaxResults,
  TollFreePrefix,
  Alpha2CountryCode
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchAvailablePhoneNumbersRequest(
    areaCode: Optional[String] = Optional.Absent,
    city: Optional[String] = Optional.Absent,
    country: Optional[Alpha2CountryCode] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    tollFreePrefix: Optional[TollFreePrefix] = Optional.Absent,
    phoneNumberType: Optional[zio.aws.chime.model.PhoneNumberType] =
      Optional.Absent,
    maxResults: Optional[PhoneNumberMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersRequest = {
    import SearchAvailablePhoneNumbersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersRequest
      .builder()
      .optionallyWith(areaCode.map(value => value: java.lang.String))(
        _.areaCode
      )
      .optionallyWith(city.map(value => value: java.lang.String))(_.city)
      .optionallyWith(
        country.map(value => Alpha2CountryCode.unwrap(value): java.lang.String)
      )(_.country)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        tollFreePrefix.map(value =>
          TollFreePrefix.unwrap(value): java.lang.String
        )
      )(_.tollFreePrefix)
      .optionallyWith(phoneNumberType.map(value => value.unwrap))(
        _.phoneNumberType
      )
      .optionallyWith(
        maxResults.map(value => PhoneNumberMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.SearchAvailablePhoneNumbersRequest.ReadOnly =
    zio.aws.chime.model.SearchAvailablePhoneNumbersRequest.wrap(buildAwsValue())
}
object SearchAvailablePhoneNumbersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.SearchAvailablePhoneNumbersRequest =
      zio.aws.chime.model.SearchAvailablePhoneNumbersRequest(
        areaCode.map(value => value),
        city.map(value => value),
        country.map(value => value),
        state.map(value => value),
        tollFreePrefix.map(value => value),
        phoneNumberType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def areaCode: Optional[String]
    def city: Optional[String]
    def country: Optional[Alpha2CountryCode]
    def state: Optional[String]
    def tollFreePrefix: Optional[TollFreePrefix]
    def phoneNumberType: Optional[zio.aws.chime.model.PhoneNumberType]
    def maxResults: Optional[PhoneNumberMaxResults]
    def nextToken: Optional[String]
    def getAreaCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("areaCode", areaCode)
    def getCity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("city", city)
    def getCountry: ZIO[Any, AwsError, Alpha2CountryCode] =
      AwsError.unwrapOptionField("country", country)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getTollFreePrefix: ZIO[Any, AwsError, TollFreePrefix] =
      AwsError.unwrapOptionField("tollFreePrefix", tollFreePrefix)
    def getPhoneNumberType
        : ZIO[Any, AwsError, zio.aws.chime.model.PhoneNumberType] =
      AwsError.unwrapOptionField("phoneNumberType", phoneNumberType)
    def getMaxResults: ZIO[Any, AwsError, PhoneNumberMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersRequest
  ) extends zio.aws.chime.model.SearchAvailablePhoneNumbersRequest.ReadOnly {
    override val areaCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.areaCode())
      .map(value => value: String)
    override val city: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.city())
      .map(value => value: String)
    override val country: Optional[Alpha2CountryCode] = zio.aws.core.internal
      .optionalFromNullable(impl.country())
      .map(value => zio.aws.chime.model.primitives.Alpha2CountryCode(value))
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val tollFreePrefix: Optional[TollFreePrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tollFreePrefix())
        .map(value => zio.aws.chime.model.primitives.TollFreePrefix(value))
    override val phoneNumberType
        : Optional[zio.aws.chime.model.PhoneNumberType] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberType())
      .map(value => zio.aws.chime.model.PhoneNumberType.wrap(value))
    override val maxResults: Optional[PhoneNumberMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.chime.model.primitives.PhoneNumberMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersRequest
  ): zio.aws.chime.model.SearchAvailablePhoneNumbersRequest.ReadOnly =
    new Wrapper(impl)
}
