package zio.aws.chime.model
import zio.aws.chime.model.primitives.E164PhoneNumber
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchAvailablePhoneNumbersResponse(
    e164PhoneNumbers: Optional[Iterable[E164PhoneNumber]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersResponse = {
    import SearchAvailablePhoneNumbersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersResponse
      .builder()
      .optionallyWith(
        e164PhoneNumbers.map(value =>
          value.map { item =>
            E164PhoneNumber.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.e164PhoneNumbers)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.SearchAvailablePhoneNumbersResponse.ReadOnly =
    zio.aws.chime.model.SearchAvailablePhoneNumbersResponse
      .wrap(buildAwsValue())
}
object SearchAvailablePhoneNumbersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.SearchAvailablePhoneNumbersResponse =
      zio.aws.chime.model.SearchAvailablePhoneNumbersResponse(
        e164PhoneNumbers.map(value => value),
        nextToken.map(value => value)
      )
    def e164PhoneNumbers: Optional[List[E164PhoneNumber]]
    def nextToken: Optional[String]
    def getE164PhoneNumbers: ZIO[Any, AwsError, List[E164PhoneNumber]] =
      AwsError.unwrapOptionField("e164PhoneNumbers", e164PhoneNumbers)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersResponse
  ) extends zio.aws.chime.model.SearchAvailablePhoneNumbersResponse.ReadOnly {
    override val e164PhoneNumbers: Optional[List[E164PhoneNumber]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.e164PhoneNumbers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.primitives.E164PhoneNumber(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersResponse
  ): zio.aws.chime.model.SearchAvailablePhoneNumbersResponse.ReadOnly =
    new Wrapper(impl)
}
