package zio.aws.chime.model
import zio.aws.chime.model.primitives.{ExternalUserIdType, GuidString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SelectedVideoStreams(
    attendeeIds: Optional[Iterable[GuidString]] = Optional.Absent,
    externalUserIds: Optional[Iterable[ExternalUserIdType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.SelectedVideoStreams = {
    import SelectedVideoStreams.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.SelectedVideoStreams
      .builder()
      .optionallyWith(
        attendeeIds.map(value =>
          value.map { item =>
            GuidString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attendeeIds)
      .optionallyWith(
        externalUserIds.map(value =>
          value.map { item =>
            ExternalUserIdType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.externalUserIds)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.SelectedVideoStreams.ReadOnly =
    zio.aws.chime.model.SelectedVideoStreams.wrap(buildAwsValue())
}
object SelectedVideoStreams {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.SelectedVideoStreams
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.SelectedVideoStreams =
      zio.aws.chime.model.SelectedVideoStreams(
        attendeeIds.map(value => value),
        externalUserIds.map(value => value)
      )
    def attendeeIds: Optional[List[GuidString]]
    def externalUserIds: Optional[List[ExternalUserIdType]]
    def getAttendeeIds: ZIO[Any, AwsError, List[GuidString]] =
      AwsError.unwrapOptionField("attendeeIds", attendeeIds)
    def getExternalUserIds: ZIO[Any, AwsError, List[ExternalUserIdType]] =
      AwsError.unwrapOptionField("externalUserIds", externalUserIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.SelectedVideoStreams
  ) extends zio.aws.chime.model.SelectedVideoStreams.ReadOnly {
    override val attendeeIds: Optional[List[GuidString]] = zio.aws.core.internal
      .optionalFromNullable(impl.attendeeIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chime.model.primitives.GuidString(item)
        }.toList
      )
    override val externalUserIds: Optional[List[ExternalUserIdType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalUserIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.primitives.ExternalUserIdType(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.SelectedVideoStreams
  ): zio.aws.chime.model.SelectedVideoStreams.ReadOnly = new Wrapper(impl)
}
