package zio.aws.chime.model
import zio.aws.chime.model.primitives.{
  ClientRequestToken,
  Metadata,
  NonEmptyContent,
  ChimeArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SendChannelMessageRequest(
    channelArn: ChimeArn,
    content: NonEmptyContent,
    `type`: zio.aws.chime.model.ChannelMessageType,
    persistence: zio.aws.chime.model.ChannelMessagePersistenceType,
    metadata: Optional[Metadata] = Optional.Absent,
    clientRequestToken: ClientRequestToken,
    chimeBearer: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.SendChannelMessageRequest = {
    import SendChannelMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.SendChannelMessageRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .content(NonEmptyContent.unwrap(content): java.lang.String)
      .`type`(`type`.unwrap)
      .persistence(persistence.unwrap)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.SendChannelMessageRequest.ReadOnly =
    zio.aws.chime.model.SendChannelMessageRequest.wrap(buildAwsValue())
}
object SendChannelMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.SendChannelMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.SendChannelMessageRequest =
      zio.aws.chime.model.SendChannelMessageRequest(
        channelArn,
        content,
        `type`,
        persistence,
        metadata.map(value => value),
        clientRequestToken,
        chimeBearer.map(value => value)
      )
    def channelArn: ChimeArn
    def content: NonEmptyContent
    def `type`: zio.aws.chime.model.ChannelMessageType
    def persistence: zio.aws.chime.model.ChannelMessagePersistenceType
    def metadata: Optional[Metadata]
    def clientRequestToken: ClientRequestToken
    def chimeBearer: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getContent: ZIO[Any, Nothing, NonEmptyContent] = ZIO.succeed(content)
    def getType: ZIO[Any, Nothing, zio.aws.chime.model.ChannelMessageType] =
      ZIO.succeed(`type`)
    def getPersistence
        : ZIO[Any, Nothing, zio.aws.chime.model.ChannelMessagePersistenceType] =
      ZIO.succeed(persistence)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.SendChannelMessageRequest
  ) extends zio.aws.chime.model.SendChannelMessageRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.channelArn())
    override val content: NonEmptyContent =
      zio.aws.chime.model.primitives.NonEmptyContent(impl.content())
    override val `type`: zio.aws.chime.model.ChannelMessageType =
      zio.aws.chime.model.ChannelMessageType.wrap(impl.`type`())
    override val persistence
        : zio.aws.chime.model.ChannelMessagePersistenceType =
      zio.aws.chime.model.ChannelMessagePersistenceType.wrap(impl.persistence())
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
    override val clientRequestToken: ClientRequestToken =
      zio.aws.chime.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.SendChannelMessageRequest
  ): zio.aws.chime.model.SendChannelMessageRequest.ReadOnly = new Wrapper(impl)
}
