package zio.aws.chime.model
import zio.aws.chime.model.primitives.{MessageId, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SendChannelMessageResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    messageId: Optional[MessageId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.SendChannelMessageResponse = {
    import SendChannelMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.SendChannelMessageResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.SendChannelMessageResponse.ReadOnly =
    zio.aws.chime.model.SendChannelMessageResponse.wrap(buildAwsValue())
}
object SendChannelMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.SendChannelMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.SendChannelMessageResponse =
      zio.aws.chime.model.SendChannelMessageResponse(
        channelArn.map(value => value),
        messageId.map(value => value)
      )
    def channelArn: Optional[ChimeArn]
    def messageId: Optional[MessageId]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.SendChannelMessageResponse
  ) extends zio.aws.chime.model.SendChannelMessageResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val messageId: Optional[MessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => zio.aws.chime.model.primitives.MessageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.SendChannelMessageResponse
  ): zio.aws.chime.model.SendChannelMessageResponse.ReadOnly = new Wrapper(impl)
}
