package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SigninDelegateGroup(
    groupName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.SigninDelegateGroup = {
    import SigninDelegateGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.SigninDelegateGroup
      .builder()
      .optionallyWith(
        groupName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupName)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.SigninDelegateGroup.ReadOnly =
    zio.aws.chime.model.SigninDelegateGroup.wrap(buildAwsValue())
}
object SigninDelegateGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.SigninDelegateGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.SigninDelegateGroup =
      zio.aws.chime.model.SigninDelegateGroup(groupName.map(value => value))
    def groupName: Optional[NonEmptyString]
    def getGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupName", groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.SigninDelegateGroup
  ) extends zio.aws.chime.model.SigninDelegateGroup.ReadOnly {
    override val groupName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.SigninDelegateGroup
  ): zio.aws.chime.model.SigninDelegateGroup.ReadOnly = new Wrapper(impl)
}
