package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SipMediaApplicationCall(
    transactionId: Optional[GuidString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.SipMediaApplicationCall = {
    import SipMediaApplicationCall.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.SipMediaApplicationCall
      .builder()
      .optionallyWith(
        transactionId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.transactionId)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.SipMediaApplicationCall.ReadOnly =
    zio.aws.chime.model.SipMediaApplicationCall.wrap(buildAwsValue())
}
object SipMediaApplicationCall {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.SipMediaApplicationCall
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.SipMediaApplicationCall =
      zio.aws.chime.model
        .SipMediaApplicationCall(transactionId.map(value => value))
    def transactionId: Optional[GuidString]
    def getTransactionId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("transactionId", transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.SipMediaApplicationCall
  ) extends zio.aws.chime.model.SipMediaApplicationCall.ReadOnly {
    override val transactionId: Optional[GuidString] = zio.aws.core.internal
      .optionalFromNullable(impl.transactionId())
      .map(value => zio.aws.chime.model.primitives.GuidString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.SipMediaApplicationCall
  ): zio.aws.chime.model.SipMediaApplicationCall.ReadOnly = new Wrapper(impl)
}
