package zio.aws.chime.model
import zio.aws.chime.model.primitives.FunctionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SipMediaApplicationEndpoint(
    lambdaArn: Optional[FunctionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.SipMediaApplicationEndpoint = {
    import SipMediaApplicationEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.SipMediaApplicationEndpoint
      .builder()
      .optionallyWith(
        lambdaArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.lambdaArn)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.SipMediaApplicationEndpoint.ReadOnly =
    zio.aws.chime.model.SipMediaApplicationEndpoint.wrap(buildAwsValue())
}
object SipMediaApplicationEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.SipMediaApplicationEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.SipMediaApplicationEndpoint =
      zio.aws.chime.model
        .SipMediaApplicationEndpoint(lambdaArn.map(value => value))
    def lambdaArn: Optional[FunctionArn]
    def getLambdaArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("lambdaArn", lambdaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.SipMediaApplicationEndpoint
  ) extends zio.aws.chime.model.SipMediaApplicationEndpoint.ReadOnly {
    override val lambdaArn: Optional[FunctionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaArn())
      .map(value => zio.aws.chime.model.primitives.FunctionArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.SipMediaApplicationEndpoint
  ): zio.aws.chime.model.SipMediaApplicationEndpoint.ReadOnly = new Wrapper(
    impl
  )
}
