package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait SipRuleTriggerType {
  def unwrap: software.amazon.awssdk.services.chime.model.SipRuleTriggerType
}
object SipRuleTriggerType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.SipRuleTriggerType
  ): zio.aws.chime.model.SipRuleTriggerType = value match {
    case software.amazon.awssdk.services.chime.model.SipRuleTriggerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.SipRuleTriggerType.TO_PHONE_NUMBER =>
      val r = ToPhoneNumber
      r
    case software.amazon.awssdk.services.chime.model.SipRuleTriggerType.REQUEST_URI_HOSTNAME =>
      val r = RequestUriHostname
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.SipRuleTriggerType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.SipRuleTriggerType =
      software.amazon.awssdk.services.chime.model.SipRuleTriggerType.UNKNOWN_TO_SDK_VERSION
  }
  case object ToPhoneNumber extends zio.aws.chime.model.SipRuleTriggerType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.SipRuleTriggerType =
      software.amazon.awssdk.services.chime.model.SipRuleTriggerType.TO_PHONE_NUMBER
  }
  case object RequestUriHostname
      extends zio.aws.chime.model.SipRuleTriggerType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.SipRuleTriggerType =
      software.amazon.awssdk.services.chime.model.SipRuleTriggerType.REQUEST_URI_HOSTNAME
  }
}
