package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SourceConfiguration(
    selectedVideoStreams: Optional[zio.aws.chime.model.SelectedVideoStreams] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.SourceConfiguration = {
    import SourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.SourceConfiguration
      .builder()
      .optionallyWith(selectedVideoStreams.map(value => value.buildAwsValue()))(
        _.selectedVideoStreams
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.SourceConfiguration.ReadOnly =
    zio.aws.chime.model.SourceConfiguration.wrap(buildAwsValue())
}
object SourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.SourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.SourceConfiguration =
      zio.aws.chime.model.SourceConfiguration(
        selectedVideoStreams.map(value => value.asEditable)
      )
    def selectedVideoStreams
        : Optional[zio.aws.chime.model.SelectedVideoStreams.ReadOnly]
    def getSelectedVideoStreams: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.SelectedVideoStreams.ReadOnly
    ] = AwsError.unwrapOptionField("selectedVideoStreams", selectedVideoStreams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.SourceConfiguration
  ) extends zio.aws.chime.model.SourceConfiguration.ReadOnly {
    override val selectedVideoStreams
        : Optional[zio.aws.chime.model.SelectedVideoStreams.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectedVideoStreams())
        .map(value => zio.aws.chime.model.SelectedVideoStreams.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.SourceConfiguration
  ): zio.aws.chime.model.SourceConfiguration.ReadOnly = new Wrapper(impl)
}
