package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartMeetingTranscriptionRequest(
    meetingId: GuidString,
    transcriptionConfiguration: zio.aws.chime.model.TranscriptionConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.StartMeetingTranscriptionRequest = {
    import StartMeetingTranscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.StartMeetingTranscriptionRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .transcriptionConfiguration(transcriptionConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.StartMeetingTranscriptionRequest.ReadOnly =
    zio.aws.chime.model.StartMeetingTranscriptionRequest.wrap(buildAwsValue())
}
object StartMeetingTranscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.StartMeetingTranscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.StartMeetingTranscriptionRequest =
      zio.aws.chime.model.StartMeetingTranscriptionRequest(
        meetingId,
        transcriptionConfiguration.asEditable
      )
    def meetingId: GuidString
    def transcriptionConfiguration
        : zio.aws.chime.model.TranscriptionConfiguration.ReadOnly
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getTranscriptionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chime.model.TranscriptionConfiguration.ReadOnly
    ] = ZIO.succeed(transcriptionConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.StartMeetingTranscriptionRequest
  ) extends zio.aws.chime.model.StartMeetingTranscriptionRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
    override val transcriptionConfiguration
        : zio.aws.chime.model.TranscriptionConfiguration.ReadOnly =
      zio.aws.chime.model.TranscriptionConfiguration
        .wrap(impl.transcriptionConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.StartMeetingTranscriptionRequest
  ): zio.aws.chime.model.StartMeetingTranscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
