package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopMeetingTranscriptionRequest(meetingId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.StopMeetingTranscriptionRequest = {
    import StopMeetingTranscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.StopMeetingTranscriptionRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.StopMeetingTranscriptionRequest.ReadOnly =
    zio.aws.chime.model.StopMeetingTranscriptionRequest.wrap(buildAwsValue())
}
object StopMeetingTranscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.StopMeetingTranscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.StopMeetingTranscriptionRequest =
      zio.aws.chime.model.StopMeetingTranscriptionRequest(meetingId)
    def meetingId: GuidString
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.StopMeetingTranscriptionRequest
  ) extends zio.aws.chime.model.StopMeetingTranscriptionRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.StopMeetingTranscriptionRequest
  ): zio.aws.chime.model.StopMeetingTranscriptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
