package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.DataRetentionInHours
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StreamingConfiguration(
    dataRetentionInHours: DataRetentionInHours,
    disabled: Optional[Boolean] = Optional.Absent,
    streamingNotificationTargets: Optional[
      Iterable[zio.aws.chime.model.StreamingNotificationTarget]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.StreamingConfiguration = {
    import StreamingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.StreamingConfiguration
      .builder()
      .dataRetentionInHours(
        DataRetentionInHours.unwrap(dataRetentionInHours): Integer
      )
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .optionallyWith(
        streamingNotificationTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streamingNotificationTargets)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.StreamingConfiguration.ReadOnly =
    zio.aws.chime.model.StreamingConfiguration.wrap(buildAwsValue())
}
object StreamingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.StreamingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.StreamingConfiguration =
      zio.aws.chime.model.StreamingConfiguration(
        dataRetentionInHours,
        disabled.map(value => value),
        streamingNotificationTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dataRetentionInHours: DataRetentionInHours
    def disabled: Optional[Boolean]
    def streamingNotificationTargets: Optional[
      List[zio.aws.chime.model.StreamingNotificationTarget.ReadOnly]
    ]
    def getDataRetentionInHours: ZIO[Any, Nothing, DataRetentionInHours] =
      ZIO.succeed(dataRetentionInHours)
    def getDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disabled", disabled)
    def getStreamingNotificationTargets: ZIO[Any, AwsError, List[
      zio.aws.chime.model.StreamingNotificationTarget.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "streamingNotificationTargets",
      streamingNotificationTargets
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.StreamingConfiguration
  ) extends zio.aws.chime.model.StreamingConfiguration.ReadOnly {
    override val dataRetentionInHours: DataRetentionInHours =
      zio.aws.chime.model.primitives
        .DataRetentionInHours(impl.dataRetentionInHours())
    override val disabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: Boolean)
    override val streamingNotificationTargets: Optional[
      List[zio.aws.chime.model.StreamingNotificationTarget.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.streamingNotificationTargets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chime.model.StreamingNotificationTarget.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.StreamingConfiguration
  ): zio.aws.chime.model.StreamingConfiguration.ReadOnly = new Wrapper(impl)
}
