package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StreamingNotificationTarget(
    notificationTarget: zio.aws.chime.model.NotificationTarget
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.StreamingNotificationTarget = {
    import StreamingNotificationTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.StreamingNotificationTarget
      .builder()
      .notificationTarget(notificationTarget.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.StreamingNotificationTarget.ReadOnly =
    zio.aws.chime.model.StreamingNotificationTarget.wrap(buildAwsValue())
}
object StreamingNotificationTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.StreamingNotificationTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.StreamingNotificationTarget =
      zio.aws.chime.model.StreamingNotificationTarget(notificationTarget)
    def notificationTarget: zio.aws.chime.model.NotificationTarget
    def getNotificationTarget
        : ZIO[Any, Nothing, zio.aws.chime.model.NotificationTarget] =
      ZIO.succeed(notificationTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.StreamingNotificationTarget
  ) extends zio.aws.chime.model.StreamingNotificationTarget.ReadOnly {
    override val notificationTarget: zio.aws.chime.model.NotificationTarget =
      zio.aws.chime.model.NotificationTarget.wrap(impl.notificationTarget())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.StreamingNotificationTarget
  ): zio.aws.chime.model.StreamingNotificationTarget.ReadOnly = new Wrapper(
    impl
  )
}
